#ifndef _MEMORY_CPP
#define _MEMORY_CPP
///////////////////////////////////////////////////////////////////////////////////////////////////////////////////

#include <Windows.H>

#include "String.H"

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////
// This functions return value must be freed externally
void *Allocate(int iBlockSz)
{
    return (void *) calloc(iBlockSz, 1);
}

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////

bool Free(void *vBuffer)
{
    if(vBuffer == NULL)
	{
		return false;
	}
    free(vBuffer);
    return true;
}

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////

void *ClearMem(void *vBuffer, int iBufSz)
{
    for(int iWPos = 0; iWPos < iBufSz; iWPos++)
    {
        ((char *)vBuffer)[iWPos] = 0;
    }

    return vBuffer;
}

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////

void *MemCopy(void *vTarget, void *vSource, int iLen)
{
	for(int iPos = 0; iPos < iLen; iPos++)
	{
		((char *)vTarget)[iPos] = ((char *)vSource)[iPos];
	}
    return vTarget;
}

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////

int MemCopyLong(char *sOutBuf, long lIn)
{
    int iWPos = 0;

	long lBuf = 0;

    if(lIn < 0)
    {
        lBuf = (0 - lIn);
    }
    else lBuf = lIn;

	do
	{
		sOutBuf[iWPos++] = '0' + (int) (lBuf % 10);
		lBuf /= 10;
	}
	while(lBuf != 0);

    if(lIn < 0)
    {
		sOutBuf[iWPos++] = '-';
	}

	ReverseString(sOutBuf, iWPos);

	sOutBuf[iWPos] = '\0';

    return iWPos;
}

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////

int MemCopyInt(char *sOutBuf, int iIn)
{
    return MemCopyLong(sOutBuf, (long) iIn);
}

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////
#endif
